unit UDrukowanie;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls,
  { wydruk }
  RpDefine, RpRave, RpBase, RpSystem,
  DataModule;

const cxNAZWISKO   = 0.5;
const cxIMIE       = 1.5;
const cxULICA      = 2.5;
const cxKODP       = 4.5;
const cxMIASTO     = 5.5;

const cLenNAZWISKO = 1;
const cLenIMIE     = 1;
const cLenULICA    = 2;
const cLenKODP     = 1;
const cLenMIASTO   = 1;

type

MPrint = class(TObject)
private
   // drukowanie
   RvSystem  : TRvSystem;

	LNazwisko : TStringList;	// tylko wskanik nie usuwa
   LImie     : TStringList;	// tylko wskanik nie usuwa
   LUlica    : TStringList;	// tylko wskanik nie usuwa
   LKodp     : TStringList;	// tylko wskanik nie usuwa
   LMiasto   : TStringList;	// tylko wskanik nie usuwa

   // Drukowanie
   { RvSystem.OnPrint }
	procedure   RvSystemPrint(Sender: TObject);
   { procedura budujca zawarto wydruku }
	procedure   StartRaveReport(Report: TBaseReport);


public
	procedure   Drukuj();
   
	constructor Create(parLNazwisko : TStringList;
   	                parLImie     : TStringList;
      	             parLUlica    : TStringList;
         	          parLKodp     : TStringList;
            	       parLMiasto   : TStringList);
end;

implementation
{------------------------------------------------------------------------------}
constructor MPrint.Create(parLNazwisko : TStringList;
                          parLImie     : TStringList;
                          parLUlica    : TStringList;
                          parLKodp     : TStringList;
                          parLMiasto   : TStringList);


begin
	LNazwisko := parLNazwisko;
	LImie     := parLImie;
	LUlica    := parLUlica;
	LKodp     := parLKodp;
	LMiasto   := parLMiasto;
end;

procedure MPrint.RvSystemPrint(Sender: TObject);
begin
	StartRaveReport(Sender as TBaseReport);
end;

procedure MPrint.Drukuj();
begin
   {
   budowanie wydruku w
   procedure StartRaveReport(Report: TBaseReport);
   }
   try
      RvSystem                         := TRvSystem.Create(Nil);
      RvSystem.OnPrint                 := RvSystemPrint;
      RvSystem.SystemPreview.FormState := wsMaximized;
      {
      RvSystem.SystemPrinter.Orientation := poLandscape;
      }

      // zmiana na system metryczny
      RvSystem.SystemPrinter.Units       := unCM;
      RvSystem.SystemPrinter.UnitsFactor := 1; // Jedna jednostka = 1 cm;
      RvSystem.SystemPrinter.Title       := 'Wydruk testowy - projekt RAVE01';
      {
      RvSystem.SystemPrinter.UnitsFactor := 2; // Jedna jednostka = 2 cm;
      }

      RvSystem.Execute();

   finally
      FreeAndNil(RvSystem);
   end;
end;

procedure MPrint.StartRaveReport(Report: TBaseReport);
var
	txt         : String;
   lp          : Integer;

   // pola:
   nazwisko    : String;
   imie        : String;
   ulica       : String;
   kodp        : String;
   miasto      : String;

begin
   {
   zwikszamy grny margines
   }
   for lp := 1 to 4 do
   begin
      Report.NewLine();
   end;

   Report.SetFont('Verdana', 10);
   Report.Bold := false;

   txt := 'Pszczyna, dnia ' + DateToStr(Date()) + ' r.';
   { wycentrowany napis, 7 cali od lewego brzegu }
	Report.PrintCenter(txt, 6.9);
   for lp := 1 to 4 do
   begin
      Report.NewLine();
   end;

   Report.SetFont('Verdana', 12);
   Report.Bold := true;
   txt := 'Lista osb - projekt RAVE01';
   Report.PrintCenter(txt, 4);

   for lp := 1 to 4 do
   begin
      Report.NewLine();
   end;


	{ bdziemy tworzy nowy raport tabularyczny, wic ta instrukcja jest konieczna }
   Report.ClearTabs();

   Report.SetFont('Times New Roman', 10);
   Report.Bold := false;

   // NAGOWEK BEGIN -----------------------------------------------------------
   Report.ClearTabs();
   { naglwki beda pisane czcionka pogrubiona }
   Report.Bold := True;
   // 0.5od lewej, szeroko kolumny 2 cale
   Report.SetTab(cxNAZWISKO, pjCenter, cLenNAZWISKO, 0, BOXLINEALL, 0);		// nazwisko
   Report.SetTab(cxIMIE    , pjCenter, cLenIMIE    , 0, BOXLINEALL, 0);     // imie
   Report.SetTab(cxULICA   , pjCenter, cLenULICA   , 0, BOXLINEALL, 0);     // ulica
   Report.SetTab(cxKODP    , pjCenter, cLenKODP    , 0, BOXLINEALL, 0);     // kodp
   Report.SetTab(cxMIASTO  , pjCenter, cLenMIASTO  , 0, BOXLINEALL, 0);     // miasto

   txt := 'NAZWISKO';
	Report.PrintTab(txt);
   txt := 'IMI';
	Report.PrintTab(txt);
   txt := 'ULICA I NR DOMU';
	Report.PrintTab(txt);
   txt := 'KOD P.';
	Report.PrintTab(txt);
   txt := 'MIASTO';
	Report.PrintTab(txt);


   Report.Bold := false;
   Report.NewLine();
   // NAGOWEK END -------------------------------------------------------------

	// POZYCJE
   for lp := 0 to LNazwisko.Count-1 do
   begin
   	if ( (lp mod 2) > 0 ) then
      begin
         Report.ClearTabs();
         Report.SetTab(cxNAZWISKO, pjLeft  , cLenNAZWISKO, 0, BOXLINEALL, 0);		// nazwisko
         Report.SetTab(cxIMIE    , pjLeft  , cLenIMIE    , 0, BOXLINEALL, 0);     // imie
         Report.SetTab(cxULICA   , pjLeft  , cLenULICA   , 0, BOXLINEALL, 0);     // ulica
         Report.SetTab(cxKODP    , pjCenter, cLenKODP    , 0, BOXLINEALL, 0);     // kodp
         Report.SetTab(cxMIASTO  , pjLeft  , cLenMIASTO  , 0, BOXLINEALL, 0);     // miasto
      end
      else begin
         Report.ClearTabs();
         Report.SetTab(cxNAZWISKO, pjLeft  , cLenNAZWISKO, 0, BOXLINEALL, 25);		// nazwisko
         Report.SetTab(cxIMIE    , pjLeft  , cLenIMIE    , 0, BOXLINEALL, 25);     // imie
         Report.SetTab(cxULICA   , pjLeft  , cLenULICA   , 0, BOXLINEALL, 25);     // ulica
         Report.SetTab(cxKODP    , pjCenter, cLenKODP    , 0, BOXLINEALL, 25);     // kodp
         Report.SetTab(cxMIASTO  , pjLeft  , cLenMIASTO  , 0, BOXLINEALL, 25);     // miasto
      end;

   	nazwisko := LNazwisko[lp];
      imie     := LImie[lp];
      ulica    := LUlica[lp];
      kodp     := LKodp[lp];
      miasto   := LMiasto[lp];

      Report.PrintTab(nazwisko);
      Report.PrintTab(imie);
      Report.PrintTab(ulica);
      Report.PrintTab(kodp);
      Report.PrintTab(miasto);

      Report.NewLine();
   end;

   // odstp
   Report.ClearTabs();
   for lp := 1 to 4 do
   begin
      Report.NewLine();
   end;


   { Razem osb }
   Report.ClearTabs();
   Report.Bold := false;
	// tym razem bez obramowania
   Report.SetTab(0.5, pjLeft , 1, 0, 0, 0);		// nazwisko
   Report.SetTab(1.6, pjLeft , 1, 0, 0, 0);     // imie

   txt := 'Razem osb:';
   Report.PrintTab(txt);
   txt := IntToStr(LNazwisko.Count);
   Report.PrintTab(txt);

   Report.ClearTabs();
   // odstp
   for lp := 1 to 4 do
   begin
      Report.NewLine();
   end;

   Report.SetFont('Times New Roman', 8);
   Report.Bold := true;
   txt := 'Delphi    2007    dla    WIN32    i    bazy   danych   (C)   2008';
   Report.PrintLeft(txt, 0.5);
end;

end.

